/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;

using Borland.Eco.Internal.DefaultImpl;
using Borland.Eco.Persistence.Connection;
using Borland.Eco.Persistence.ORMapping;
using Borland.Eco.Services;
using Borland.Eco.Globalization;

namespace Borland.Eco.Persistence
{

	public interface IDistributedTransactionParticipant
	{
		// SHDB ITransaction, but we don't want to depend on using System.EnterpriseServices;
		void EnlistInTransaction(object transaction);
	}

	///<summary>
	///Superclass for all persistence mappers that persist to a relational database.
	///</summary>
	public abstract class AbstractPersistenceMapperDb: PersistenceMapper
	{
		private int m_ActiveCount;
		protected int ActiveCount
		{
			get { return m_ActiveCount;}
			set { m_ActiveCount = value; }
		}
		private IPersistenceMapperWithIDatabase m_PmapperWithDb;
		protected IPersistenceMapperWithIDatabase PmapperWithDb
		{
			get { return m_PmapperWithDb; }
		}
		protected void SetPersistenceMapperWithIDatabase(IPersistenceMapperWithIDatabase value)
		{
			m_PmapperWithDb = value;
		}

		private ITypeSystemService m_TypeSystemService;

		private EcoCompatibilityMode m_CompatibilityMode;
		///<summary>
		///This compatibility mode is only used when the RuntimeMappingProvider is null.
		///It controls the names of system-tables and columns. If you want more control
		///over the settings, add your own DefaultORMappingProvider component and set
		///the RuntimeMappingProvider to this component
		///</summary>
		public EcoCompatibilityMode CompatibilityMode
		{
			get { return m_CompatibilityMode;}
			set {
				m_CompatibilityMode = value;
				SetCompatibilityMode(value);
			}
		}

		protected AbstractPersistenceMapperDb()
		{
			CompatibilityMode = EcoCompatibilityMode.EcoIII;
		}

		protected virtual void SetCompatibilityMode(EcoCompatibilityMode mode)
		{
			m_DefaultRunTimeMappingProvider.SetEcoCompatibilityMode(mode);
		}

		private readonly DefaultORMappingBuilder m_DefaultRunTimeMappingProvider = new DefaultORMappingBuilder();
		private IORMappingProvider m_RunTimeMappingProvider = null;
		private TimeSpan m_VersionGranularity = new TimeSpan(0);
		private GetDateTimeDelegate m_GetDateTime;

		private AbstractSyncHandler m_SyncHandler;
		private readonly IPersistenceHandleDbImpl m_persistenceHandleDbImpl = CoreGate.CreatePersistenceHandleDbImpl();

		protected ITypeSystemService TypeSystemService
		{
			get { return m_TypeSystemService; }
		}
		protected void SetTypeSystemService(ITypeSystemService value)
		{
			m_TypeSystemService = value;
		}

		protected IPersistenceHandleDbImpl PersistenceHandleDb
		{
			get { return m_persistenceHandleDbImpl; }
		}

		protected void EnsureNotActive()
		{
			if (m_ActiveCount > 0)
				throw new InvalidOperationException(PersistenceStringRes.sNoValueChangeOnActivePersistenceMapper);
		}

		[LocalizableCategory(typeof(PersistenceStringRes), "sCategorySynchronization")]
		[LocalizableDescription(typeof(PersistenceStringRes), "sPropertySyncHandler")]
		[DefaultValue(null)]
		public AbstractSyncHandler SyncHandler
		{
			get { return m_SyncHandler; }
			set { m_SyncHandler=value; }
		}

		[LocalizableCategory(typeof(PersistenceStringRes), "sCategoryMapping")]
		[LocalizableDescription(typeof(PersistenceStringRes), "sPropertyRunTimeMappingProvider")]
		[DefaultValue(null)]
		public IORMappingProvider RunTimeMappingProvider
		{
			get { return m_RunTimeMappingProvider; }
			set
			{
				EnsureNotActive();
				m_RunTimeMappingProvider = value;
			}
		}

		[Obsolete("Sync can no longer be activated by setting SyncActive. Set the SyncHandler property instead.", true)]
		public bool SyncActive
		{
			set {}
		}

		[Obsolete("HistoryLength has moved to the SyncHandler component", false)]
		public int HistoryLength
		{
			set {}
		}

		///<summary>
		/// This property returns the RunTimeMappingProvider that will actually be used in runtime. If the RunTimeMappingProvider
		/// property is not set, this property will return a DefaultOrMappingProvider
		///</summary>
		[Browsable(false)]
		public IORMappingProvider EffectiveRunTimeMappingProvider
		{
			get
			{
				return (m_RunTimeMappingProvider != null) ? m_RunTimeMappingProvider : m_DefaultRunTimeMappingProvider;
			}
		}

		[LocalizableCategory(typeof(PersistenceStringRes), "sCategoryVersioning")]
// FIXME		[LocalizableDescription()]
		[DefaultValue(null)]
		public GetDateTimeDelegate OnGetCurrentTime
		{
			get { return m_GetDateTime; }
			set
			{
				EnsureNotActive();
				m_GetDateTime = value;
			}
		}

		[LocalizableCategory(typeof(PersistenceStringRes), "sCategoryVersioning")]
		[LocalizableDescription(typeof(PersistenceStringRes), "sPropertyClockLogGranularity")]
		public TimeSpan VersionGranularity
		{
			get { return m_VersionGranularity; }
			set
			{
				EnsureNotActive();
				m_VersionGranularity = value;
			}
		}


		public abstract void CloseConnections(bool force);

		protected override void Dispose(bool disposing)
		{
			if (disposing)
				CloseConnections(true);
			base.Dispose(disposing);
		}
	}
}
